*! version 5.0
* 13 August 2018
* NIDS
* Merging individuals and households across all waves.

/*  
NOTE TO USER
This do file merges all the individual level and household level datasets from all waves. 
Note: the HHRoster is not merged in because of duplicates on pid as a result of multiple memberships allowed for an individual.

* NB
This do file does not create a balanced panel dataset and as such the interview outcomes need to be taken into account when performing analysis.

If one would like to merge in the HHRoster information, they can do so in the loop below 
 */
 
*===========================================================================================================================================
* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global IN "C:\Users\Admin\Desktop\Data" //File path to where data is located. Change this path according to where your data folder is located on your computer.
global TYPE "Anon"						// Type of data being used, Anon or Secure	

cd "$IN"

*===========================================================================================================================================

clear all
set more off
set maxvar 20000 

//Appending Individual level data sets and merging to the household level data sets for each wave

local i=1
while `i'<=5 {

global VersionIN: dir "$IN\Wave `i'" files "Adult*.dta", respectcase
global VersionIN = subinstr($VersionIN,"Adult_W`i'_","",.)
global VersionIN = subinstr("$VersionIN",".dta","",.)

use "$IN\Wave `i'\Adult_W`i'_$VersionIN.dta"
append using "$IN\Wave `i'\Child_W`i'_$VersionIN.dta" "$IN\Wave `i'\Proxy_W`i'_$VersionIN.dta"
merge m:1 w`i'_hhid using "Wave `i'\HHQuestionnaire_W`i'_$VersionIN.dta"
drop if _merge!=3
drop _merge
merge m:1 w`i'_hhid using "$IN\Wave `i'\hhderived_W`i'_$VersionIN.dta"
drop if _merge!=3
drop _merge
merge 1:1 pid using "$IN\Wave `i'\indderived_W`i'_$VersionIN.dta"
drop if _merge!=3
drop _merge
save wave`i'_merged, replace
local i=`i'+1
}


use wave1_merged, clear
merge 1:1 pid using wave2_merged
drop _merge
merge 1:1 pid using wave3_merged
drop _merge
merge 1:1 pid using wave4_merged
drop _merge
merge 1:1 pid using wave5_merged
drop _merge
save allwave_merged, replace 
       
use "$IN\Wave 5\Link_File_W5_$VersionIN.dta", clear
merge 1:1 pid using allwave_merged
cap drop _merge
save NIDS_1_2_3_4_5.dta, replace

*===========================================================================================================================================

erase wave1_merged.dta
erase wave2_merged.dta
erase wave3_merged.dta
erase wave4_merged.dta

*===========================================================================================================================================
*THE END
